/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.ref.AppModel;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.ParameterUtil;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JRESelectException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.util.JfxHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.plugin.cache.JarCacheUtil;
import sun.plugin2.applet.Applet2ClassLoader;
import sun.plugin2.applet.Applet2ClassLoaderCache;
import sun.plugin2.applet.Applet2ExecutionContext;
import sun.plugin2.applet.Applet2ManagerCache;
import sun.plugin2.applet.Applet2StopListener;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.main.server.JVMHealthData;
import sun.plugin2.util.ParameterNames;

public class Applet2Manager
extends Plugin2Manager {
    private static final String VERSION_TAG = "version=";
    private static final String PRELOAD = "preload";
    private boolean initializedJarVersionMap;
    private Map<String, String> jarVersionMap = new HashMap<String, String>();
    private Map<String, String> preloadJarMap = new HashMap<String, String>();
    private List<String> newStyleJarList = new ArrayList<String>();
    private Applet2ClassLoaderCache classLoaderCache;
    private volatile Applet2ClassLoaderCache.Entry classLoaderCacheEntry;
    private volatile String classLoaderCacheKey;
    private Applet2ManagerCache instanceCache;
    private boolean usingLegacyLifeCycle;
    private String legacyCacheKey;
    private Applet2StopListener legacyStopListener;
    private URL expectedMainURL = null;
    private URL[] allJarURLs = null;
    private Map<String, DeploymentRuleSet> _drsMap = new HashMap<String, DeploymentRuleSet>();
    private DeploymentRuleSet mainAppletDeploymentRuleSet = null;

    public Applet2Manager(Applet2ClassLoaderCache applet2ClassLoaderCache, Applet2ManagerCache applet2ManagerCache, boolean bl) {
        super(bl);
        this.classLoaderCache = applet2ClassLoaderCache;
        this.instanceCache = applet2ManagerCache;
        MemoryCache.resetFileExistenceCheck();
    }

    public void setAppletExecutionContext(Applet2ExecutionContext applet2ExecutionContext) {
        super.setAppletExecutionContext(applet2ExecutionContext);
        String string = this.getParameter("legacy_lifecycle");
        if (string != null && string.equalsIgnoreCase("true")) {
            this.usingLegacyLifeCycle = true;
            this.legacyCacheKey = this.instanceCache.getCacheKey(this.getDocumentBase().toString(), (Map)applet2ExecutionContext.getAppletParameters());
        } else {
            this.usingLegacyLifeCycle = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin2ClassLoader getAppletClassLoader() {
        Applet2Manager applet2Manager = this;
        synchronized (applet2Manager) {
            if (this.loader == null) {
                Applet2ClassLoaderCache.Entry entry = this.getClassLoaderCacheEntry();
                if (entry != null) {
                    this.loader = entry.getClassLoader();
                    if (this.loader == null) {
                        throw new InternalError("Error during bootstrapping of ClassLoader");
                    }
                } else {
                    this.loader = this.getOrCreatePlugin2ClassLoader();
                }
            }
            return this.loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup getAppletThreadGroup() {
        Applet2Manager applet2Manager = this;
        synchronized (applet2Manager) {
            if (this.appletThreadGroup == null) {
                Applet2ClassLoaderCache.Entry entry = this.getClassLoaderCacheEntry();
                if (entry != null) {
                    this.appletThreadGroup = entry.getThreadGroup();
                    if (this.appletThreadGroup == null) {
                        throw new InternalError("Error during bootstrapping of ThreadGroup");
                    }
                } else {
                    this.appletThreadGroup = this.getOrCreateAppletThreadGroup();
                }
            }
            return this.appletThreadGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppContext getAppletAppContext() {
        Applet2Manager applet2Manager = this;
        synchronized (applet2Manager) {
            if (this.appletAppContext == null) {
                Applet2ClassLoaderCache.Entry entry = this.getClassLoaderCacheEntry();
                if (entry != null) {
                    this.appletAppContext = entry.getAppContext();
                    if (this.appletAppContext == null) {
                        throw new InternalError("Error during bootstrapping of AppContext");
                    }
                } else {
                    this.appletAppContext = this.getOrCreateAppletAppContext();
                }
                this.registerInAppContext(this.appletAppContext);
            }
            return this.appletAppContext;
        }
    }

    public String getAppletUniqueKey() {
        String string = "|";
        URL uRL = this.getDocumentBase();
        if (uRL != null) {
            string = string + uRL.toString();
        }
        string = string + "|";
        URL uRL2 = this.getCodeBase();
        if (uRL2 != null) {
            string = string + uRL2.toString();
        }
        string = string + "|";
        String string2 = this.getJarFiles();
        if (string2 != null) {
            string = string + string2;
        }
        string = string + "|";
        return string;
    }

    public String getLegacyLifeCycleCacheKey() {
        if (!this.usingLegacyLifeCycle) {
            throw new IllegalStateException("Only legal for applets using the legacy lifecycle");
        }
        return this.legacyCacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.usingLegacyLifeCycle) {
            throw new IllegalStateException("May only call destroy() for applets using the legacy lifecycle");
        }
        long l = this.getAppletStopTimeout();
        final Plugin2ClassLoader plugin2ClassLoader = this.getAppletClassLoader();
        ThreadGroup threadGroup = this.getAppletThreadGroup();
        String string = "thread destroy applet-" + this.getCode();
        final Thread thread = new Thread(threadGroup, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Applet2Manager.this.getApplet2Adapter().destroy();
                }
                catch (Throwable throwable) {
                    Applet2Manager.this.invalidateClassLoaderCacheEntry();
                    throwable.printStackTrace();
                }
                Object object = Applet2Manager.this.stopLock;
                synchronized (object) {
                    Applet2Manager.this.stopLock.notifyAll();
                }
            }
        }, string);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                thread.setContextClassLoader((ClassLoader)((Object)plugin2ClassLoader));
                return null;
            }
        });
        long l2 = System.currentTimeMillis();
        Object object = this.stopLock;
        synchronized (object) {
            thread.start();
            try {
                this.stopLock.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.unregisterFromAppContext(this.appletAppContext);
        this.cleanupAppContext(l2, l, this.legacyStopListener);
        if (this.getApplet2Adapter() != null) {
            this.getApplet2Adapter().cleanup();
        }
    }

    public int getPermissionRequestType() {
        String string = this.getParameter("permissions");
        if ("all-permissions".equals(string)) {
            return 2;
        }
        if ("sandbox".equals(string)) {
            return 1;
        }
        return 0;
    }

    public String getTitle() {
        String string = this.getParameter("java_applet_title");
        if (string == null || string.length() == 0) {
            string = this.getName();
        }
        return string;
    }

    public AppInfo getAppInfo() {
        AppInfo appInfo = new AppInfo();
        appInfo.setTitle(this.getTitle());
        URL uRL = (URL)ToolkitStore.get().getAppContext().get((Object)"deploy-mainjarurlinappcontext");
        if (uRL != null) {
            appInfo.setFrom(uRL);
        } else {
            appInfo.setFrom(this.getCodeBase());
        }
        appInfo.setDocumentBase(this.getDocumentBase());
        try {
            appInfo.setLapURL(new URL(appInfo.getFrom() + "/" + appInfo.getTitle() + "/" + appInfo.getDocumentBase().getHost()));
        }
        catch (Exception exception) {
            appInfo.setLapURL(appInfo.getFrom());
            Trace.ignored((Throwable)exception);
        }
        appInfo.setSecurity(this.getPermissionRequestType());
        URL uRL2 = this.getExpectedMain();
        if (uRL2 != null) {
            appInfo.setEMURL(uRL2);
            appInfo.setEMVersion((String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + uRL2)));
        }
        appInfo.setAppArgs("##docbase:" + HttpUtils.removeQueryStringFromURL((URL)this.getDocumentBase()) + "##Parameters:" + this.getParametersString());
        appInfo.setAppModel(this.getAppModel());
        return appInfo;
    }

    private AppModel.SecurityMode getSecurityMode() {
        String string = this.getParameter("permissions");
        if ("all-permissions".equals(string)) {
            return AppModel.SecurityMode.ALL_PERMISSIONS;
        }
        if ("sandbox".equals(string)) {
            return AppModel.SecurityMode.SANDBOX;
        }
        return null;
    }

    private AppModel getAppModel() {
        AppModel appModel = new AppModel();
        appModel.setType(AppModel.Type.APPLET);
        appModel.setSecurityMode(this.getSecurityMode());
        appModel.setTitle(this.getTitle());
        appModel.setVendor(null);
        appModel.setDescription(null);
        appModel.setCodebase(this.getCodeBase());
        appModel.setLocation(this.getDocumentBase());
        appModel.setMainClass(this.getCode());
        for (URL uRL : this.getAllJarURLs()) {
            if (uRL == null) continue;
            appModel.addJarResource(uRL, null);
        }
        return appModel;
    }

    private URL createJarURL(String string, URL uRL) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException2) {
                Trace.ignored((Throwable)malformedURLException2);
                return null;
            }
        }
    }

    private URL getExpectedMain() {
        if (this.expectedMainURL == null) {
            URL uRL = this.getCodeBase();
            String string = this.getJarFiles();
            if (string != null) {
                String[] stringArray = Applet2Manager.splitJarList(string, false);
                if (stringArray.length > 0) {
                    this.expectedMainURL = this.createJarURL(stringArray[0], uRL);
                }
            } else {
                String string2 = this.getCode();
                if (string2 != null) {
                    if (string2.endsWith(".class")) {
                        string2 = string2.substring(0, string2.lastIndexOf(46));
                    }
                    string2 = string2.replace('.', '/') + ".class";
                    try {
                        this.expectedMainURL = new URL(uRL, string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Trace.ignored((Throwable)malformedURLException);
                    }
                }
            }
            Trace.println((String)("Expected Main URL: " + this.expectedMainURL), (TraceLevel)TraceLevel.SECURITY);
        }
        return this.expectedMainURL;
    }

    private URL[] getAllJarURLs() {
        if (this.allJarURLs == null) {
            URL uRL = this.getCodeBase();
            String string = this.getJarFiles();
            if (string != null) {
                String[] stringArray = Applet2Manager.splitJarList(string, false);
                if (stringArray.length > 0) {
                    this.allJarURLs = new URL[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.allJarURLs[i] = this.createJarURL(stringArray[i], uRL);
                    }
                }
            } else {
                this.allJarURLs = new URL[0];
            }
        }
        return this.allJarURLs;
    }

    private String getParametersString() {
        Map<String, String> map = this.getAppletParameters();
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        for (int i = 0; i < ParameterNames.internalParams.length; ++i) {
            hashMap.remove(ParameterNames.internalParams[i]);
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(SystemUtils.encodeString((String)objectArray[i]) + "=" + SystemUtils.encodeString((String)hashMap.get(objectArray[i])) + ",");
        }
        return stringBuffer.toString();
    }

    public URL getMainLocation(Class clazz) {
        URL uRL = null;
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (this.getJarFiles() != null) {
            uRL = codeSource.getLocation();
        } else {
            URL uRL2 = codeSource.getLocation();
            String string = this.getCode();
            if (string.endsWith(".class")) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            string = string.replace('.', '/') + ".class";
            try {
                uRL = new URL(uRL2, string);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored((Throwable)malformedURLException);
                uRL = uRL2;
            }
        }
        return uRL;
    }

    private static AppRef getHTMLAppRef(Applet2Manager applet2Manager, URL uRL) {
        return new AppRef(AppRef.Type.HTML, applet2Manager.getTitle(), applet2Manager.getDocumentBase(), null, (URL)null);
    }

    public DeploymentRuleSet getMainDeploymentRuleSet(URL uRL) {
        DeploymentRuleSet deploymentRuleSet = this._drsMap.get(uRL.toString());
        if (deploymentRuleSet == null) {
            CodeRef codeRef = new CodeRef(uRL, null);
            AppRef appRef = Applet2Manager.getHTMLAppRef(this, uRL);
            Trace.println((String)("Non-jnlp appRef: " + appRef), (TraceLevel)TraceLevel.RULESET);
            Trace.println((String)("Non-jnlp codeRef: " + codeRef), (TraceLevel)TraceLevel.RULESET);
            deploymentRuleSet = DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
            this._drsMap.put(uRL.toString(), deploymentRuleSet);
            String string = deploymentRuleSet.getVersionString();
            if (string != null) {
                this.setParameter("__applet_request_version", string);
            }
        }
        if (this.mainAppletDeploymentRuleSet == null) {
            this.mainAppletDeploymentRuleSet = deploymentRuleSet;
        }
        return deploymentRuleSet;
    }

    public DeploymentRuleSet getMainDeploymentRuleSet() {
        if (this.mainAppletDeploymentRuleSet != null) {
            return this.mainAppletDeploymentRuleSet;
        }
        return new BlockRule(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownAppContext(AppContext appContext, long l, long l2, Applet2StopListener applet2StopListener, boolean bl) {
        if (!this.usingLegacyLifeCycle) {
            super.shutdownAppContext(appContext, l, l2, applet2StopListener, bl);
        } else {
            this.legacyStopListener = applet2StopListener;
            if (bl) {
                this.instanceCache.put(this);
                Object object = this.stopLock;
                synchronized (object) {
                    this.shouldStop = false;
                    this.stopSuccessful = false;
                }
            } else {
                this.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupAppContext(long l, long l2, Applet2StopListener applet2StopListener) {
        Applet2ClassLoaderCache applet2ClassLoaderCache = null;
        Applet2ClassLoaderCache.Entry entry = null;
        AppContext appContext = null;
        Applet2Manager applet2Manager = this;
        synchronized (applet2Manager) {
            appContext = this.appletAppContext;
            this.appletAppContext = null;
            applet2ClassLoaderCache = this.classLoaderCache;
            this.classLoaderCache = null;
            entry = this.classLoaderCacheEntry;
            this.classLoaderCacheEntry = null;
        }
        long l3 = l2 - (System.currentTimeMillis() - l);
        if (entry != null) {
            assert (applet2ClassLoaderCache != null);
            Applet2Manager applet2Manager2 = this;
            synchronized (applet2Manager2) {
                applet2ClassLoaderCache.release(entry, this, applet2StopListener, l3);
            }
        } else {
            this.destroyAppContext(appContext, applet2StopListener, l3);
        }
    }

    protected Plugin2ClassLoader newClassLoader() {
        URL uRL = this.getCodeBase();
        Applet2ClassLoader applet2ClassLoader = Applet2ClassLoader.newInstance(uRL);
        if (this.isForDummyApplet()) {
            applet2ClassLoader.setCodebaseLookup(false);
        }
        return applet2ClassLoader;
    }

    protected synchronized void initJarVersionMap() {
        block12: {
            block11: {
                if (this.initializedJarVersionMap) {
                    return;
                }
                this.initializedJarVersionMap = true;
                int n = 1;
                String string = this.getParameter("archive_" + n);
                if (string == null) break block11;
                while (string != null) {
                    String[] stringArray = Applet2Manager.splitJarList(string, false);
                    String string2 = null;
                    String string3 = null;
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string4 = stringArray[i];
                        if (string2 == null) {
                            string2 = string4;
                            continue;
                        }
                        if ((string4 = string4.toLowerCase()).startsWith(VERSION_TAG)) {
                            string3 = string4.substring(VERSION_TAG.length());
                            continue;
                        }
                        if (!string4.equals(PRELOAD)) continue;
                        bl = true;
                    }
                    if (string2 != null) {
                        if (bl) {
                            this.preloadJarMap.put(string2, string3);
                        }
                        this.jarVersionMap.put(string2, string3);
                        this.newStyleJarList.add(string2);
                    }
                    string = this.getParameter("archive_" + ++n);
                }
                break block12;
            }
            String string = this.getParameter("cache_archive");
            String string5 = this.getParameter("cache_version");
            String string6 = this.getParameter("cache_archive_ex");
            try {
                this.jarVersionMap = JarCacheUtil.getJarsWithVersion(string, string5, string6);
            }
            catch (Exception exception) {
                Trace.printException((Throwable)exception, (String)ResourceManager.getMessage((String)"cache.error.text"), (String)ResourceManager.getMessage((String)"cache.error.caption"));
            }
            if (string6 == null) break block12;
            String[] stringArray = Applet2Manager.splitJarList(string6, false);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = Applet2Manager.splitOptionString(stringArray[i]);
                if (stringArray2.length <= 1 || stringArray2[1] == null || stringArray2[1].toLowerCase().indexOf(PRELOAD) == -1) continue;
                String string7 = null;
                if (stringArray2.length > 2) {
                    string7 = stringArray2[2];
                }
                this.preloadJarMap.put(stringArray2[0], string7);
            }
        }
    }

    private void storeJarVersionMapInAppContext() {
        for (Map.Entry<String, String> entry : this.jarVersionMap.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            URL uRL = null;
            try {
                uRL = new URL(this.getCodeBase(), string);
                if (!URLUtil.checkTargetURL((URL)this.getCodeBase(), (URL)uRL)) {
                    throw new SecurityException("Permission denied: " + uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
            if (uRL == null) continue;
            ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL), (Object)string2);
            URL uRL2 = DownloadEngine.getKnownRedirectFinalURL((URL)uRL);
            if (URLUtil.sameURLs((URL)uRL2, (URL)uRL)) continue;
            ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL2), (Object)string2);
        }
    }

    protected void setupAppletAppContext() {
        this.storeJarVersionMapInAppContext();
        super.setupAppletAppContext();
    }

    private void installJfxIfNeeded() throws ExitException {
        String string = this.getParameter("javafx_version");
        if (string == null) {
            return;
        }
        if (ToolkitStore.isUsingPreferredToolkit((int)11, (int)1)) {
            return;
        }
        if (super.isAppletRelaunched()) {
            throw new ExitException(new Throwable("Cannot initiate FX Toolkit for plugin mode."), 3);
        }
        try {
            URL uRL = new URL("http://javaweb.sfbay.sun.com/~hj156752/awtless/fx/installer/fxinstaller.jnlp");
            JfxHelper.installJfxRuntime((URL)uRL, (String)string, (Preloader)this.getPreloaderDelegate());
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        this.setParameter("__jfx_installed", String.valueOf(true));
        Trace.println((String)"Applet relaunch due to FX", (TraceLevel)TraceLevel.BASIC);
        this.appletRelaunch(null, false);
    }

    protected void performDesktopIntegration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadJarFiles() throws ExitException {
        int n = ResourceProvider.get().incrementInternalUse();
        try {
            this._loadJarFiles();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ResourceProvider.get().decrementInternalUse(n);
            throw throwable;
        }
        ResourceProvider.get().decrementInternalUse(n);
    }

    private void _loadJarFiles() throws ExitException {
        block7: {
            this.installJfxIfNeeded();
            try {
                JarCacheUtil.preload(this.getCodeBase(), this.preloadJarMap);
            }
            catch (Exception exception) {
                Trace.printException((Throwable)exception, (String)ResourceManager.getMessage((String)"cache.error.text"), (String)ResourceManager.getMessage((String)"cache.error.caption"));
            }
            try {
                String string = this.getJarFiles();
                Applet2ClassLoader applet2ClassLoader = (Applet2ClassLoader)this.getAppletClassLoader();
                String[] stringArray = File.separator;
                String string2 = System.getProperty("java.home") + (String)stringArray + "lib" + (String)stringArray + "applet";
                this.loadLocalJarFiles(applet2ClassLoader, string2);
                if (Config.getOSName().equalsIgnoreCase("Windows")) {
                    String string3 = Config.getSystemHome() + (String)stringArray + "Lib" + (String)stringArray + "Untrusted";
                    this.loadLocalJarFiles(applet2ClassLoader, string3);
                }
                if (string == null) {
                    return;
                }
                stringArray = Applet2Manager.splitJarList(string, false);
                for (int i = 0; i < stringArray.length; ++i) {
                    applet2ClassLoader.addJar(stringArray[i]);
                }
            }
            catch (Throwable throwable) {
                int n;
                ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
                int n2 = n = exitException.getReason() == 0 ? 0 : -1;
                if (n == 0) break block7;
                throw exitException;
            }
        }
    }

    protected void appletRelaunch(JREDesc jREDesc, boolean bl) throws JRESelectException {
        JVMParameters jVMParameters = JVMParameters.getRunningJVMParameters();
        List list = jVMParameters.getCommandLineArguments(false, false, false, true, false, -1);
        String string = ArgumentParsingUtil.encodeArgumentList((List)list);
        throw new JRESelectException(jREDesc, string, bl);
    }

    protected void appletSSVRelaunch() throws JRESelectException {
        URL uRL = null;
        String string = this.getParameter("__applet_ssv_version");
        if (string != null && string.indexOf("_") > 0) {
            try {
                uRL = new URL(JREInfo.getHomeJRE().getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored((Throwable)malformedURLException);
            }
        }
        JREDesc jREDesc = new JREDesc(string, 0L, 0L, null, uRL, null);
        Trace.println((String)"AppletRelaunch due to SSV", (TraceLevel)TraceLevel.BASIC);
        this.appletRelaunch(jREDesc, false);
    }

    protected void checkRunningJVMToolkitSatisfying() throws JRESelectException {
    }

    protected void checkRunningJVMArgsSatisfying() throws JRESelectException {
        if (super.isAppletRelaunched()) {
            return;
        }
        JVMHealthData jVMHealthData = JVMHealthData.getCurrent();
        if (!jVMHealthData.isHealthy()) {
            if (DEBUG) {
                System.out.println("Relaunch due to unhealthy JVM: " + jVMHealthData);
            }
            Trace.println((String)"AppletRelaunch due to health", (TraceLevel)TraceLevel.BASIC);
            this.appletRelaunch(new JREDesc(null, 0L, 0L, null, null, null), false);
        }
        if (!ParameterUtil.hasRunningVMRequiredArgs((String)JREInfo.getHomeJRE().getVmArgs())) {
            Trace.println((String)"AppletRelaunch due to JCP VM args", (TraceLevel)TraceLevel.BASIC);
            this.appletRelaunch(new JREDesc(null, 0L, 0L, null, null, null), true);
        }
    }

    private void loadLocalJarFiles(Applet2ClassLoader applet2ClassLoader, String string) {
        File file = new File(string);
        if (file.exists()) {
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".jar");
                }
            });
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    URL uRL = new File(string + File.separator + stringArray[i]).toURI().toURL();
                    applet2ClassLoader.addLocalJar(uRL);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        }
    }

    protected String getJarFiles() {
        int n;
        if (!this.newStyleJarList.isEmpty()) {
            return Applet2Manager.buildJarList(this.newStyleJarList.toArray(new String[0]));
        }
        String string = this.getParameter("cache_archive_ex");
        if (string != null && (n = string.indexOf(";")) >= 0) {
            string = Applet2Manager.buildJarList(Applet2Manager.splitJarList(string, true));
        }
        String string2 = Applet2Manager.buildJarList(new String[]{string, this.getParameter("cache_archive"), this.getParameter("java_archive"), this.getParameter("archive")});
        if (DEBUG) {
            System.out.println("Applet2Manager.getJarFiles() for applet ID " + this.appletID + " Jar Files:" + string2);
        }
        return string2;
    }

    protected String getCodeSourceLocations() {
        return this.getJarFiles();
    }

    private synchronized Applet2ClassLoaderCache.Entry getClassLoaderCacheEntry() {
        if (this.classLoaderCache == null) {
            return null;
        }
        if (this.classLoaderCacheEntry == null) {
            this.initJarVersionMap();
            this.verifyJarVersions();
            this.classLoaderCacheEntry = this.classLoaderCache.get(this.getClassLoaderCacheKey(), this);
            if (DEBUG) {
                System.out.println("Applet2Manager.getClassLoaderCacheEntry() for applet ID " + this.appletID + ": ClassLoader=" + Applet2Manager.objToString((Object)this.classLoaderCacheEntry.getClassLoader()) + ", ThreadGroup=" + Applet2Manager.objToString(this.classLoaderCacheEntry.getThreadGroup()) + ", AppContext=" + Applet2Manager.objToString(this.classLoaderCacheEntry.getAppContext()));
            }
        }
        return this.classLoaderCacheEntry;
    }

    protected synchronized void invalidateClassLoaderCacheEntry() {
        if (this.classLoaderCache != null && this.classLoaderCacheEntry != null) {
            this.classLoaderCache.markNotCacheable(this.classLoaderCacheEntry);
        }
    }

    protected boolean usingLegacyLifeCycle() {
        return this.usingLegacyLifeCycle;
    }

    protected void clearUsingLegacyLifeCycle() {
        this.usingLegacyLifeCycle = false;
    }

    private static String objToString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(object.getClass().getName());
        stringBuffer.append("@~0x");
        stringBuffer.append(Integer.toHexString(System.identityHashCode(object)));
        return stringBuffer.toString();
    }

    public static Applet2ClassLoaderCache.EntryCreator getCacheEntryCreator() {
        return new CacheEntryCreator();
    }

    private String getClassLoaderCacheKey() {
        if (this.classLoaderCacheKey == null) {
            String string = this.getParameter("classloader-policy");
            String string2 = this.getParameter("permissions");
            if (string2 == null && string != null && string.equals("classic")) {
                this.classLoaderCacheKey = this.getCodeBase().toString();
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getCodeBase());
                String string3 = this.getJarFiles();
                if (string3 != null) {
                    stringBuffer.append(",");
                    stringBuffer.append(string3);
                }
                if (string2 != null) {
                    stringBuffer.append(",");
                    stringBuffer.append(string2);
                }
                this.classLoaderCacheKey = stringBuffer.toString();
            }
        }
        return this.classLoaderCacheKey;
    }

    private void verifyJarVersions() {
        assert (this.classLoaderCache != null);
        boolean bl = false;
        URL uRL = this.getCodeBase();
        for (Map.Entry<String, String> entry : this.jarVersionMap.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            try {
                String string3;
                URL uRL2 = new URL(uRL, string);
                if (!URLUtil.checkTargetURL((URL)uRL, (URL)uRL2)) {
                    throw new SecurityException("Permission denied: " + uRL2);
                }
                Trace.msgNetPrintln((String)"cache.version_checking", (Object[])new Object[]{string, string2});
                if (string2 == null || (string3 = ResourceProvider.get().getCurrentVersion(uRL2)) == null || string3.compareTo(string2) == 0) continue;
                bl = true;
                break;
            }
            catch (MalformedURLException malformedURLException) {
                if (!DEBUG) continue;
                malformedURLException.printStackTrace();
            }
        }
        if (bl) {
            this.classLoaderCache.markNotCacheable(this.getClassLoaderCacheKey());
        }
    }

    static class CacheEntryCreator
    implements Applet2ClassLoaderCache.EntryCreator {
        CacheEntryCreator() {
        }

        public void createAll(Applet2Manager applet2Manager, Applet2ClassLoaderCache.Entry entry) {
            if (Plugin2Manager.DEBUG) {
                System.out.println("Applet2Manager executing createAll() for entry " + entry.getClassLoaderCacheKey());
            }
            entry.setClassLoader((Applet2ClassLoader)applet2Manager.getOrCreatePlugin2ClassLoader());
            entry.setThreadGroup(applet2Manager.getOrCreateAppletThreadGroup());
            entry.setAppContext(applet2Manager.getOrCreateAppletAppContext());
        }

        public void createThreadGroupAndAppContext(Applet2Manager applet2Manager, Applet2ClassLoaderCache.Entry entry) {
            if (Plugin2Manager.DEBUG) {
                System.out.println("Applet2Manager executing createTGAndAC() for entry " + entry.getClassLoaderCacheKey());
            }
            applet2Manager.loader = entry.getClassLoader();
            if (applet2Manager.loader == null) {
                throw new InternalError("Error during bootstrapping of new ThreadGroup and AppContext");
            }
            entry.setThreadGroup(applet2Manager.getOrCreateAppletThreadGroup());
            entry.setAppContext(applet2Manager.getOrCreateAppletAppContext());
            Applet2ClassLoader applet2ClassLoader = entry.getClassLoader();
            applet2ClassLoader.setThreadGroup(entry.getThreadGroup());
            applet2ClassLoader.setAppContext(entry.getAppContext());
        }

        public void destroyThreadGroupAndAppContext(Applet2Manager applet2Manager, Applet2StopListener applet2StopListener, long l, Applet2ClassLoaderCache.Entry entry) {
            if (Plugin2Manager.DEBUG) {
                System.out.println("Applet2Manager executing destroyTGAndAC() for entry " + entry.getClassLoaderCacheKey());
            }
            applet2Manager.destroyAppContext(entry.getAppContext(), applet2StopListener, l);
            entry.setThreadGroup(null);
            entry.setAppContext(null);
            Applet2ClassLoader applet2ClassLoader = entry.getClassLoader();
            applet2ClassLoader.setThreadGroup(null);
            applet2ClassLoader.setAppContext(null);
        }
    }
}

