package fr.minecraftforgefrance.client.custommenu;

import java.util.EnumSet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;

public class CustomMenuTickHandler implements ITickHandler
{
	@Override
	public void tickStart(EnumSet<TickType> type, Object... tickData)
	{

	}

	@Override
	public void tickEnd(EnumSet<TickType> type, Object... tickData)
	{
		if(type.equals(EnumSet.of(TickType.CLIENT)))
		{
			Minecraft mc = Minecraft.getMinecraft();
			GuiScreen currentScreen = mc.currentScreen;
			GuiCustomMainMenu customMenu = new GuiCustomMainMenu();

			if(currentScreen instanceof GuiMainMenu)
			{
				mc.displayGuiScreen(customMenu);
			}
		}
	}

	@Override
	public EnumSet<TickType> ticks()
	{
		return EnumSet.of(TickType.CLIENT);
	}

	@Override
	public String getLabel()
	{
		return "MFF - Custom client";
	}
}